#include <SupportDefs.h>
#include <unistd.h>
#include <math.h>

int 
main()
{
	int i;
	double phase=0.0;
	const int kMaxBufferSize = 0x10000;
	// set phase increment to 90 cycles/4K buffer
	// (~440Hz at 20KHz sampling rate)
	// so it aligns with buffer and we only have
	// to calculate it once.
	// = wT where T = 1/20000 and w = 2*pi*f
	const double incr = 0.138058271;
	uint8 buf[kMaxBufferSize];
	for (i = 0; i < kMaxBufferSize; i++) {
		// convert from float to unsigned 8-bit audio
		buf[i] = (uint8)(sin(phase) * 127.0) + 128;
		phase += incr;
	}
	
	// run for 24 buffers
	// (~ 5s for 4K buffers at 20KHz sampling rate)
	for (i=0; i<24; i++) {		
		write(1, buf, kMaxBufferSize);
	}
	return 0;
}
